'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit

' Drive type constants
Const Unknown = 0 
Const Removable = 1  ' Removable medium
Const Fixed = 2      ' Fixed medium (hard disk)
Const Remote = 3     ' Network drive
Const CDROM = 4      ' CD-ROM
Const RAMDisk = 5    ' RAM disk

Dim Text, Title
Dim fso, oDrive, curDrive    ' Object variables

Dim drtype(6)
drtype(0) = " Unknown "
drtype(1) = " Removable "
drtype(2) = " Fixed "
drtype(3) = " Remote "
drtype(4) = " CDROM "
drtype(5) = " RAMDisk "

Text = "Drives" & vbCrLf & vbCrLf
Title = "Raffaele Chiatto Produced"

' Create FileSystemObject object to access the file system.
Set fso = WScript.CreateObject("Scripting.FileSystemObject")

Set oDrive = fso.Drives    ' Get Drives collection.

For Each curDrive In oDrive       ' All drive objects
    Text = Text & curDrive.DriveLetter & vbTab  ' Drive letter
    Text = Text & drtype(curDrive.DriveType)
    Select Case curDrive.DriveType      ' Identify drive type.
        Case Removable                  ' Removable medium
            If curDrive.IsReady Then
                Text = Text & curDrive.VolumeName ' Local drive
            End If    

        Case CDROM                      ' CD-ROM
            If curDrive.IsReady Then
                Text = Text & curDrive.VolumeName ' Local drive
            End If    

        Case Remote 
            Text = Text & curDrive.ShareName  ' Network drive

        Case Else                       ' Other medium
            Text = Text & curDrive.VolumeName  ' Local drive
    End Select
    Text = Text & vbCrLf
Next

MsgBox Text, vbOKOnly + vbInformation, Title

'*** End